//%attributes = {}
//******************************************************************************
//Method: SDA_Startup
//Written by  Tod Gentille on 10/14/97
//
//Purpose: Launches the Design Assistant Palette and inits the the vars needed by 
//other routines
//NOTE:YOU NEED TO CALL THIS METHOD in the Database Method, On Startup 
//or in a method called from On Startup 
//
//Version: Design Assistant 2000, version 1.0b5, 3/22/99
//
//Copyright 1997-1998 Syncor Systems, 
//******************************************************************************

//Since the Design Assistant is really only useful if you have a design environmen
//don't clutter the screen with a palette that is not needed if the app's compiled
//this also allows the end user to distribute their compiled app with
//SDA still installed 
If (Not:C34(Is compiled mode:C492))
	
	Compiler_SDA  //c: PM
	
	SDA_strt_NAMED_CONSTANTS  //MUST call this first  - change these for non-English languages  
	SDA_Strt_RESOURCE_CONSTANTS  //constants that we get into IP vars from resources
	SDA_strt_Prefs  //you can tweak these for optimal performance on your system
	SDA_strt_InitPaletteVars
	SDA_ClipboardLoadContents
	
	C_LONGINT:C283(<>lSDA_FloatWinProcessID)  //the floating window's process ID    
	C_TEXT:C284(<>tSDA_Scrap)  //used in several functions to hold temporary text contents
	//only assumed to have valid info during the life of the button's operation
	
	C_LONGINT:C283(<>lSDA_DesignPID)
	<>lSDA_DesignPID:=SDA_util_ProcessNum  //This does not work because the Design process does not
	// exist at this time in the startup, cjh, 3/3/99
	//  
	C_BOOLEAN:C305(<>bSDA_FilepackIsHere)
	<>bSDA_FilepackIsHere:=SDA_strt_IsFilePackHere
	
	SET TEXT TO PASTEBOARD:C523(" ")  //so that the paste command will be enabled
	SDA_ma_Startup  //Init the stuff for the method analysis module
	
	//-------------------------------------------------------------------------------
	//Only allow keyboard shortcuts in versions prior to 6.5  
	If (SDA_util_IsPost60x)
		
		If (<>bSDA_EnableShortcuts)  //set in SDA_Prefs
			//don't use SDA_EnableShortcuts because the value in the pop up is already correct
			ON EVENT CALL:C190("SDA_OnEventHandler"; "$SDA_OnEvent")
			
			SDA_DisableShortcuts  //this will clear ON EVENT CALL which doesn't have anything anyway and update popu
		End if 
	Else 
		SDA_DisableShortcuts
	End if 
	
	<>lSDA_FloatWinProcessID:=New process:C317("SDA_PaletteOpen"; 64000; "$DesignPaletteProc"; *)
	
	_O_MAP FILE TYPES:C366("SDAM"; "SDA"; "SDA Methods")  //set up mapping for 4D document commands
End if   // checking for compiled
